package de.uni_passau.fim.dagmar.util;


public class Table<T> {
    private int[] sizes;
    private T[] table;
    
    public Table(ArrayFactory<T> arrayFactory, int... sizes) {
        this.sizes = sizes;
        int totalSize = 1;
        for (int size : sizes) {
            totalSize *= size;
        }
        table = arrayFactory.create(totalSize);
    }
    
    public final T get(int... sig) {
        if (sig.length != sizes.length) {
            throw new IllegalArgumentException();
        }
        
        return table[index(sig)];
    }
    
    public final void put(T t, int... sig) {
        table[index(sig)] = t;
    }
    
    private int index(int[] sig) {
        if (sig.length == 0) return 1;
        // Just a clumsy form of foldLeft
        int index = sig[0];
        if (index > sizes[0]) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < sig.length; i++) {
            int sigI = sig[i];
            int sizeI = sizes[i];
            if (sigI >= sizeI) {
                throw new IllegalArgumentException();
            }
            index = index * sizeI + sigI;
        }
        return index;
    }
}
