package de.uni_passau.fim.dagmar.util;

/**
 * A range of numbers. It represents the set {@code {from, from + step, from + 2
 * * step, ..., to}.
 * 
 * @param <T>
 *            Type of the represented numbers.
 */
public class Range<T extends Number> {
    /*
     * The least number of this range.
     */
    private T from;

    /*
     * The greatest number of this range.
     */
    private T to;

    /*
     * The difference between two consecutive numbers within this range.
     */
    private T step;

    /**
     * Constructs a new {@code Range}.
     * 
     * @param from
     *            the least number of this range.
     * @param to
     *            the greatest number of this range.
     * @param step
     *            the difference between two consecutive numbers within this
     *            range.
     */
    public Range(T from, T to, T step) {
        this.from = from;
        this.to = to;
        this.step = step;
    }

    /**
     * Returns the least number of this range.
     * 
     * @return the least number of this range.
     */
    public T getFrom() {
        return from;
    }

    /**
     * Returns the greatest number of this range.
     * 
     * @return the greatest number of this range.
     */
    public T getTo() {
        return to;
    }

    /**
     * Returns the difference between two consecutive numbers within this range.
     * 
     * @return the difference between two consecutive numbers within this range.
     */
    public T getStep() {
        return step;
    }
}
