package de.uni_passau.fim.dagmar.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;

public class Combinatorics {
    private ArrayList<Integer> candidates;
    private ArrayList<BigInteger> weights;
    private BigInteger weightSum;
    
    public Combinatorics() {
        candidates = new ArrayList<Integer>();
        weights = new ArrayList<BigInteger>();
        weightSum = BigInteger.ZERO;
    }
    
    public void add(int candidate, BigInteger weight) {
        candidates.add(candidate);
        weights.add(weight);
        weightSum = weightSum.add(weight);
    }
    
    public boolean isEmpty() {
        return candidates.isEmpty();
    }
    
    public int draw(Random random) {
        BigInteger ticket = randomBigInt(random, weightSum);
        BigInteger maxTicket = BigInteger.ZERO;
        for (int i = 0; i < candidates.size(); i++) {
            maxTicket = maxTicket.add(weights.get(i));
            if (ticket.compareTo(maxTicket) < 0) {
                return candidates.get(i);
            }
        }
        throw new AssertionError();
    }
    
    public static BigInteger randomBigInt(Random random, BigInteger exclusive) {
        int bitLength = exclusive.bitLength();
        BigInteger result;
        do {
            result = new BigInteger(bitLength, random);
        } while (result.compareTo(exclusive) >= 0);
        return result;
    }
    
    public static BigInteger faculty(int n) {
        return n <= 1
                ? BigInteger.ONE
                : BigInteger.valueOf(n).multiply(faculty(n - 1));
    }
    
    public static BigInteger binom(int n, int k) {
        return faculty(n).divide(faculty(k)).divide(faculty(n - k));
    }
}
