package de.uni_passau.fim.dagmar.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class CollectionUtil {
    /**
     * Returns an element uniformly drawn from the collection with the
     * specified source of randomness.
     * @param <E> The type of the element
     * @param collection the collection to draw from
     * @param random the source of randomness
     * @return an element uniformly drawn from the collection with the
     * specified source of randomness.
     */
    public static <E> E draw(Collection<E> collection, Random random) {
        int skip = random.nextInt(collection.size());

        Iterator<E> iter = collection.iterator();
        for (int i = 0; i < skip; i++) {
            iter.next();
        }

        return iter.next();
    }
    
    /**
     * Returns a new {@link LinkedHashSet} containing the consecutive sequence
     * of integers from {@code from} to {@code to}, inclusively.
     * @param from the least number of the sequence to return
     * @param to the greates number of the sequence to return
     * @return a new {@link LinkedHashSet} containing the consecutive sequence
     * of integers from {@code from} to {@code to}, inclusively.
     */
    public static Set<Integer> createRangeSet(int from, int to) {
        Set<Integer> result = new LinkedHashSet<Integer>();
        
        for (int i = from; i <= to; i++) {
            result.add(i);
        }
        
        return result;
    }
    
    /**
     * Swaps the {@code i}-th with the {@code j}-th element of the specified
     * array.
     * @param a the array, in which two elements are swapped.
     * @param i the index of the first element to swap
     * @param j the index of the second element to swap
     */
    public static void swap(int[] a, int i, int j) {
        int clip = a[i];
        a[i] = a[j];
        a[j] = clip;
    }
}
