package de.uni_passau.fim.dagmar.arguments;

import java.util.EnumSet;
import java.util.Iterator;

import de.uni_passau.fim.dagmar.arguments.DAGmarProgramArguments.EmbeddingKind;

public class SharedProgramArguments extends ProgramArguments {
    
    public SharedProgramArguments(String[] args)
            throws ProgramArgumentException {
        super(args);
    }
    
    protected EmbeddingKind obtainEmbedding(boolean leveled) throws ProgramArgumentException {
        EnumSet<EmbeddingKind> embeddings = EnumSet.noneOf(EmbeddingKind.class);
        
        if (containsFlag("p")) {
            embeddings.add(EmbeddingKind.PROPER);
        }
        
        if (containsFlag("el")) {
            embeddings.add(EmbeddingKind.EMBEDDING);
        }
        
        if (containsFlag("ed")) {
            embeddings.add(EmbeddingKind.DUMMY_EMBEDDING);
        }
         
        if (embeddings.size() > 1) {
            throw new ProgramArgumentException("options -p, -el, and -ed are mutually exclusive");
        }
        
        Iterator<EmbeddingKind> iter = embeddings.iterator();
        
        if (iter.hasNext()) {
            if (!leveled) {
                throw new ProgramArgumentException("options -p, -el, and -ed must be combined with -l");
            }
            return iter.next();
        } else {
            return EmbeddingKind.NONE;
        }
    }
}
